#install.packages("survival")
#install.packages("survminer")


#library packages
library(survival)
library(survminer)

clusterFile="group.txt"    #Typed result file
cliFile="OS.txt"               #survival data file
setwd("E:\\metabolism\\LGG\\16.ANN_validation\\CGGA\\5.subgroup_Sur\\metabolismcluster\\C2")      

#read input file
cluster=read.table(clusterFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
cli$futime=cli$futime/365
colnames(cli)=c("futime", "fustat")

#data merge
sameSample=intersect(row.names(cluster), row.names(cli))
rt=cbind(cli[sameSample,,drop=F], cluster[sameSample,,drop=F])

#Survival Difference Statistics
length=length(levels(factor(rt$group)))
diff=survdiff(Surv(futime, fustat) ~ group, data = rt)
pValue=1-pchisq(diff$chisq, df=length-1)
HR=(diff$obs[2]/diff$exp[2])/(diff$obs[1]/diff$exp[1])
if(pValue<0.001){
	pValue="p<0.001"
}else{
	pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ group, data = rt)
#print(surv_median(fit))

#Plot a survival curve
bioCol=c("#223D6C","#D20A13","#FFD121","#088247","#1363A3","#F38664","#FF0000","#6E568C","#7CC767","#11AA4D")
bioCol=bioCol[1:length]
surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=F,
		           pval=pValue,
		           pval.size=6,
		           legend.title="group",
		           legend.labs=levels(factor(rt[,"group"])),
		           legend = c(0.8, 0.8),
		           font.legend=10,
		           xlab="Time(years)",
		           break.time.by = 1,
		           palette = bioCol,
		           surv.median.line = "hv",
		           risk.table=T,
		           cumevents=F,
		           risk.table.height=.25)
pdf(file="survival.pdf",onefile = FALSE,width=6.5,height=6.5)
print(surPlot)
dev.off()

